install.packages("plyr")
install.packages("dplyr")
install.packages("ggplot2")
install.packages("RColorBrewer")
install.packages("ggpubr")
install.packages("wesanderson")
install.packages("ggsignif")
install.packages("tidyverse")
install.packages("scales")  
install.packages("tidyr")
install.packages("tibble")
install.packages("openxlsx")
install.packages("ggplot2")
install.packages("ggpubr")
install.packages("survminer")
install.packages("survival")
install.packages("Rcpp")
install.packages("broom")

library(plyr)
library(dplyr)
library(ggplot2)
library(RColorBrewer)
library(ggpubr)
library(wesanderson)
library(ggsignif)
library(tidyverse)
library(scales)  
library(tidyr)
library(tibble)
library(openxlsx)
library(ggplot2)
library(ggpubr)
library(survminer)
library(survival)
library(Rcpp)
library(broom)


#change to the main folder containing your three folders: input, output, and R code
base_directory <- "C:/Users/Angela/Desktop/cox regression datasheets/Lifespan Assays Cox Regression/DR Replicates/Cox regression DR rep 2"
setwd(base_directory)
rcode_folder <- paste(base_directory, "R code", sep = "/")
input_folder <- paste(base_directory, "input", sep = "/")
output_folder <- paste(base_directory, "output", sep = "/")

data = read.csv(paste(input_folder, "cox regression DR rep 2.csv", sep = "/"), header = TRUE, sep = ',')
data <- na.omit(data)

names(data)[1] <- "condition"
data$technical.replicate <- "A"
data$replicate_group <- interaction(data$condition, data$technical.replicate)

#change RNAi and genotype to be the experimental variables in your data. If you have more than 2, you can add more than 2 to the list.
conditions <- c("fed.DR", "genotype")

source(file.path(rcode_folder, "reformat_data_include_rupture.R"))
source(file.path(rcode_folder, "reformat_data_censor_rupture.R"))
source(file.path(rcode_folder, "format_for_ggplot.R"))
source(file.path(rcode_folder, "log_rank_all_groups.R"))
source(file.path(rcode_folder, "basic_stats.R"))

##only run one of the following two lines, depending on if you want to censor rupture


reformatted <- reformat_data_censor_rupture(data, conditions)

reformatted <- reformat_data_include_rupture(data, conditions)


#this version is food enough for survfit, but now reformat again for ggplot

to_plot <- format_for_ggplot(reformatted, conditions)
write.csv(to_plot, paste(output_folder, "data_formatted_to_plot.csv", sep = "/"), row.names = FALSE)

#now run statistics on your data
#this function will give you mean lifespan, standard deviation, hazard ratios, and log-rank comparisons across all conditions
basic_stats(reformatted, output_folder)


##use the following code to run cox regressions

#first use subset to only include the portion of your dataset you want your cox regression performed on
subset <- subset(reformatted, RNAi %in% c("EV", "npr-37"))
subset <- reformatted

#set your control variables to be zero
subset[subset$fed.DR == "fed",]$fed.DR <- 0
subset[subset$genotype == "WT",]$genotype <- 0

#then, create your cox regression model. To do this, replace RNAi and genotype with the conditions you want to look for an interaction between
cox <- coxph(Surv(time, censored) ~ fed.DR*genotype, data = subset)
summary(cox)
to_save <- tidy(cox)
to_save$exp_coef_haz_ratio <- exp(to_save$estimate)
#rename the text in quotes if you use a different subset
write.csv(to_save, paste(output_folder, "cox_regression_DR_rep2.csv", sep ="/"), row.names = FALSE)

#I can stop here!!!
#now, if you want, you can use R to plot your lifespan data as well. If you don't want to do this on R, you can use prism or excel with data from the to_plot file saved to the output folder
setwd(output_folder)

#set this to be the variable you want to color by
cols_key <- c("EV" = "black",
              "nlp-17" = "#5500D2") 

#set this to be the variable you want the line to be encoded by
line_key <- c("TU3311" = "solid",
              "vhl-1; TU3311" = "dotted")

#set this to be the variable you want the shape to be encoded by
shape_key <- c("TU3311" = 4,
               "vhl-1; TU3311" = 19)

#subset <- subset(to_plot, fake.lawn %in% c("200ul"))
subset <- to_plot

#use subset to select the portion of your dataset you want to include in the plot
subset <- subset(subset, RNAi %in% c("EV", "nlp-17"))

#in the first line, change the variable after color, linetype, and shape to match what you specified in the keys above
ggplot(subset, aes(group = condition, x= time, y = survival, color = RNAi, 
                   linetype = genotype, 
                   shape = genotype)) + 
  #how thick the line is
  geom_line(size = 1) +
  #how large the dots are
  geom_point(size = 3) +
  theme_classic() +
  #the location of the legend
  theme(legend.position = c(.25, .42),
        #specifies to not put a title over the legend
        legend.title=element_blank(),
        #specifies font size, color, face, justification, and angles of all text in your plot
        axis.text.x = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = .5, vjust = .6, face = "bold"),
        axis.text.y = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = 1, vjust = 0, face = "bold"),  
        axis.title.x = element_text(color = "black", size = 24, angle = 0,
                                    hjust = .5, vjust = .5,
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        axis.title.y = element_text(color = "black", size = 24, angle = 90,
                                    hjust = .5, vjust = .5, face = "bold",
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        title = element_text(color = "black", size = 16, face = "bold"),
        legend.text = element_text(color = "black", size = 14, face = "bold"),
        #specifies the color and size of your axis lines and ticks
        axis.line = element_line(colour = 'black', size = 1),
        axis.ticks = element_line(colour = "black", size = 1),
        #makes the plot background white with no lines in the background
        panel.background = element_rect(fill = "white",
                                        colour = "white"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  #loads in the key for how to color/linetype/shape each group
  scale_color_manual(values = cols_key) +
  scale_linetype_manual(values = line_key, aes(size = 3)) +
  scale_shape_manual(values = shape_key) +
  #specifies the range of the x axis. Change limits if your worms are longer lived
  scale_x_continuous(limits = c(0, 45), expand = c(0, NA)) +
  #specifies the y axis. Don't change.
  scale_y_continuous(limits = c(0,105), expand = c(0, NA)) +
  #x and y axis labels
  labs(x ="Days from Egg", y = "Percent Survival") 

#saves as a tiff file (easy to open and use w powerpoint) and a pdf file (editable vector file good for submitting papers)
ggsave("nlp-17.tiff", width = 6, height =5)
ggsave("nlp-17.pdf", width = 6, height =5)


subset <- to_plot

subset <- subset(subset, RNAi %in% c("EV", "npr-43"))

cols_key <- c("EV" = "black",
              
              # "flp-15" = "#9B2226",
              #"npr-3" = "#F4A261",
              #"flp-21" = "#FF0066",
              #"npr-37" = "#2A9D8F",
              "npr-43" = "#0180FF")
            #  "nlp-17" = "#5500D2") 

ggplot(subset, aes(group = condition, x= time, y = survival, color = RNAi, 
                   linetype = genotype, 
                   shape = genotype)) + 
  geom_line(size = 1) +
  geom_point(size = 3) +
  theme_classic() +
  theme(legend.position = c(.25, .42),
        legend.title=element_blank(),
        axis.text.x = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = .5, vjust = .6, face = "bold"),
        axis.text.y = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = 1, vjust = 0, face = "bold"),  
        axis.title.x = element_text(color = "black", size = 24, angle = 0,
                                    hjust = .5, vjust = .5,
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        axis.title.y = element_text(color = "black", size = 24, angle = 90,
                                    hjust = .5, vjust = .5, face = "bold",
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        title = element_text(color = "black", size = 16, face = "bold"),
        legend.text = element_text(color = "black", size = 14, face = "bold"),
        axis.line = element_line(colour = 'black', size = 1),
        axis.ticks = element_line(colour = "black", size = 1),
        panel.background = element_rect(fill = "white",
                                        colour = "white"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  scale_color_manual(values = cols_key) +
  scale_linetype_manual(values = line_key, aes(size = 3)) +
  scale_shape_manual(values = shape_key) +
  scale_x_continuous(limits = c(0, 45), expand = c(0, NA)) +
  scale_y_continuous(limits = c(0,105), expand = c(0, NA)) +
  labs(x ="Days from Egg", y = "Percent Survival") 

ggsave("npr-43.tiff", width = 6, height =5)
ggsave("npr-43.pdf", width = 6, height =5)




subset <- to_plot

subset <- subset(subset, RNAi %in% c("EV", "npr-37"))

cols_key <- c("EV" = "black",
              
              # "flp-15" = "#9B2226",
              #"npr-3" = "#F4A261",
              #"flp-21" = "#FF0066",
              "npr-37" = "#2A9D8F")
             # "npr-43" = "#0180FF")
#  "nlp-17" = "#5500D2") 

ggplot(subset, aes(group = condition, x= time, y = survival, color = RNAi, 
                   linetype = genotype, 
                   shape = genotype)) + 
  geom_line(size = 1) +
  geom_point(size = 3) +
  theme_classic() +
  theme(legend.position = c(.25, .42),
        legend.title=element_blank(),
        axis.text.x = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = .5, vjust = .6, face = "bold"),
        axis.text.y = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = 1, vjust = 0, face = "bold"),  
        axis.title.x = element_text(color = "black", size = 24, angle = 0,
                                    hjust = .5, vjust = .5,
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        axis.title.y = element_text(color = "black", size = 24, angle = 90,
                                    hjust = .5, vjust = .5, face = "bold",
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        title = element_text(color = "black", size = 16, face = "bold"),
        legend.text = element_text(color = "black", size = 14, face = "bold"),
        axis.line = element_line(colour = 'black', size = 1),
        axis.ticks = element_line(colour = "black", size = 1),
        panel.background = element_rect(fill = "white",
                                        colour = "white"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  scale_color_manual(values = cols_key) +
  scale_linetype_manual(values = line_key, aes(size = 3)) +
  scale_shape_manual(values = shape_key) +
  scale_x_continuous(limits = c(0, 42), expand = c(0, NA)) +
  scale_y_continuous(limits = c(0,105), expand = c(0, NA)) +
  labs(x ="Days from Egg", y = "Percent Survival") 

ggsave("npr-37.tiff", width = 6, height =5)
ggsave("npr-37.pdf", width = 6, height =5)





subset <- to_plot

subset <- subset(subset, RNAi %in% c("EV", "flp-15"))

cols_key <- c("EV" = "black",
              
              "flp-15" = "#9B2226")
#"npr-3" = "#F4A261",
#"flp-21" = "#FF0066",
#"npr-37" = "#2A9D8F",
#"flp-15" = "#0180FF")
#  "nlp-17" = "#5500D2") 

ggplot(subset, aes(group = condition, x= time, y = survival, color = RNAi, 
                   linetype = genotype, 
                   shape = genotype)) + 
  geom_line(size = 1) +
  geom_point(size = 3) +
  theme_classic() +
  theme(legend.position = c(.22, .32),
        legend.title=element_blank(),
        axis.text.x = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = .5, vjust = .6, face = "bold"),
        axis.text.y = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = 1, vjust = 0, face = "bold"),  
        axis.title.x = element_text(color = "black", size = 24, angle = 0,
                                    hjust = .5, vjust = .5,
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        axis.title.y = element_text(color = "black", size = 24, angle = 90,
                                    hjust = .5, vjust = .5, face = "bold",
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        title = element_text(color = "black", size = 16, face = "bold"),
        legend.text = element_text(color = "black", size = 14, face = "bold"),
        axis.line = element_line(colour = 'black', size = 1),
        axis.ticks = element_line(colour = "black", size = 1),
        panel.background = element_rect(fill = "white",
                                        colour = "white"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  scale_color_manual(values = cols_key) +
  scale_linetype_manual(values = line_key, aes(size = 3)) +
  scale_shape_manual(values = shape_key) +
  scale_x_continuous(limits = c(0, 42), expand = c(0, NA)) +
  scale_y_continuous(limits = c(0,105), expand = c(0, NA)) +
  labs(x ="Days from Egg", y = "Percent Survival") 

ggsave("flp-15.tiff", width = 6, height =5)
ggsave("flp-15.pdf", width = 6, height =5)






subset <- to_plot

subset <- subset(subset, RNAi %in% c("EV", "npr-3"))

cols_key <- c("EV" = "black",
              
              # "flp-15" = "#9B2226",
              "npr-3" = "#F4A261")
#"flp-21" = "#FF0066",
#"npr-37" = "#2A9D8F",
#"npr-3" = "#0180FF")
#  "nlp-17" = "#5500D2") 

ggplot(subset, aes(group = condition, x= time, y = survival, color = RNAi, 
                   linetype = genotype, 
                   shape = genotype)) + 
  geom_line(size = 1) +
  geom_point(size = 3) +
  theme_classic() +
  theme(legend.position = c(.25, .42),
        legend.title=element_blank(),
        axis.text.x = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = .5, vjust = .6, face = "bold"),
        axis.text.y = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = 1, vjust = 0, face = "bold"),  
        axis.title.x = element_text(color = "black", size = 24, angle = 0,
                                    hjust = .5, vjust = .5,
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        axis.title.y = element_text(color = "black", size = 24, angle = 90,
                                    hjust = .5, vjust = .5, face = "bold",
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        title = element_text(color = "black", size = 16, face = "bold"),
        legend.text = element_text(color = "black", size = 14, face = "bold"),
        axis.line = element_line(colour = 'black', size = 1),
        axis.ticks = element_line(colour = "black", size = 1),
        panel.background = element_rect(fill = "white",
                                        colour = "white"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  scale_color_manual(values = cols_key) +
  scale_linetype_manual(values = line_key, aes(size = 3)) +
  scale_shape_manual(values = shape_key) +
  scale_x_continuous(limits = c(0, 42), expand = c(0, NA)) +
  scale_y_continuous(limits = c(0,105), expand = c(0, NA)) +
  labs(x ="Days from Egg", y = "Percent Survival") 

ggsave("npr-3.tiff", width = 6, height =5)
ggsave("npr-3.pdf", width = 6, height =5)





subset <- to_plot

subset <- subset(subset, RNAi %in% c("EV", "flp-21"))

cols_key <- c("EV" = "black",
              
              # "flp-15" = "#9B2226",
              #"npr-3" = "#F4A261",
              "flp-21" = "#FF0066")
#"npr-37" = "#2A9D8F",
#   "flp-21" = "#0180FF")
#  "nlp-17" = "#5500D2") 

ggplot(subset, aes(group = condition, x= time, y = survival, color = RNAi, 
                   linetype = genotype, 
                   shape = genotype)) + 
  geom_line(size = 1) +
  geom_point(size = 3) +
  theme_classic() +
  theme(legend.position = c(.25, .42),
        legend.title=element_blank(),
        axis.text.x = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = .5, vjust = .6, face = "bold"),
        axis.text.y = element_text(color = "black", size = 16, angle = 0, 
                                   hjust = 1, vjust = 0, face = "bold"),  
        axis.title.x = element_text(color = "black", size = 24, angle = 0,
                                    hjust = .5, vjust = .5,
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        axis.title.y = element_text(color = "black", size = 24, angle = 90,
                                    hjust = .5, vjust = .5, face = "bold",
                                    margin = margin(t = 0, r = 10, b = 0, l = 0)),
        title = element_text(color = "black", size = 16, face = "bold"),
        legend.text = element_text(color = "black", size = 14, face = "bold"),
        axis.line = element_line(colour = 'black', size = 1),
        axis.ticks = element_line(colour = "black", size = 1),
        panel.background = element_rect(fill = "white",
                                        colour = "white"),
        panel.grid.major = element_blank(),
        panel.grid.minor = element_blank()) +
  scale_color_manual(values = cols_key) +
  scale_linetype_manual(values = line_key, aes(size = 3)) +
  scale_shape_manual(values = shape_key) +
  scale_x_continuous(limits = c(0, 42), expand = c(0, NA)) +
  scale_y_continuous(limits = c(0,105), expand = c(0, NA)) +
  labs(x ="Days from Egg", y = "Percent Survival") 

ggsave("flp-21.tiff", width = 6, height =5)
ggsave("flp-21.pdf", width = 6, height =5)






